--[[
	ReduceMaintenanceCosts.lua
	
	Author:		Samuel
	Date:		11.12.2024
	Version:	1.0

	Changelog: 		
		v1.0 11.12.2024 Mise en place du mod
]]


ReduceMaintenanceCosts = {};
ReduceMaintenanceCosts.currentModDirectory = "";

for _, mod in pairs(g_modManager.mods) do
	if mod.title == "Reduced maintenance costs" or mod.title == "Verringerte Wartungskosten" or mod.title == "Réduction des coûts de maintenance" then		
		if g_modIsLoaded[tostring(mod.modName)] then	
			ReduceMaintenanceCosts.currentModDirectory = mod.modDir;
			
			break;
		end;
	end;
end;

function ReduceMaintenanceCosts.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Wearable, specializations);
end;

function ReduceMaintenanceCosts.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, ReduceMaintenanceCosts);
	end;
end;

function ReduceMaintenanceCosts:onLoad(savegame)
	local modDesc = loadXMLFile("modDesc", ReduceMaintenanceCosts.currentModDirectory .. "modDesc.xml");

	self.spec_wearable.dividieFactorRepair = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.reduceMaintenanceCosts#dividieFactorRepair"));
	self.spec_wearable.dividieFactorRepaint = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.reduceMaintenanceCosts#dividieFactorRepaint"));

	delete(modDesc);
end;

function ReduceMaintenanceCosts.registerOverwrittenFunctions(vehicleType)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getRepairPrice", ReduceMaintenanceCosts.getRepairPrice);
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getRepaintPrice", ReduceMaintenanceCosts.getRepaintPrice);
end

function ReduceMaintenanceCosts:getRepairPrice(superFunc)
	return superFunc(self) / self.spec_wearable.dividieFactorRepair;
end;

function ReduceMaintenanceCosts:getRepaintPrice(superFunc)
	return superFunc(self) / self.spec_wearable.dividieFactorRepaint;
end;