--
-- automaticMilkSale
--
-- @author  nilBrain
-- @date 	24.06.2022
-- @node	This Script do sold atomaticly Milk from Husbandry.
-- @update	implement PalletSpowner

automaticMilkSale = {};

automaticMilkSale.FILLTYPES_TO_HUSBANDRY = {
	["COW"] = {"MILK BUFFALOMILK"},
	["GOAT"] = {"GOATMILK"},
	["SHEEP"] = {"GOATMILK"}
};


function automaticMilkSale:loadMap(mapFilename)
	if g_currentMission:getIsServer() then
		g_messageCenter:subscribe(MessageType.HOUR_CHANGED, self.hourChanged, self);
	end;
end;

function automaticMilkSale:deleteMap()
	if g_currentMission:getIsServer() then
		g_messageCenter:unsubscribe(MessageType.HOUR_CHANGED, self);
	end;
end;

function automaticMilkSale:sellMilk()
	for _, placeable in ipairs(g_currentMission.husbandrySystem.placeables) do
		for hType, fillTypes in pairs(automaticMilkSale.FILLTYPES_TO_HUSBANDRY) do
			if placeable:getAnimalTypeIndex() == AnimalType[hType] then
				if placeable:getOwnerFarmId() ~= FarmManager.SPECTATOR_FARM_ID then
					if placeable:getNumOfAnimals() > 0 then
						for _, _fillTypes in ipairs(fillTypes) do
							for _, fillType in ipairs(string.split(_fillTypes, " ")) do
								local fillTypeIndex = g_fillTypeManager:getFillTypeIndexByName(fillType);
								if fillTypeIndex ~= nil then
									--milk
									local fillLevel = placeable:getHusbandryFillLevel(fillTypeIndex);
									placeable:removeHusbandryFillLevel(nil, fillLevel, fillTypeIndex);
									local price = fillLevel * g_currentMission.economyManager:getPricePerLiter(fillTypeIndex);
									g_currentMission:addMoney(price, placeable:getOwnerFarmId(), MoneyType.SOLD_MILK, true, true);

									--paletSpawner
									local spec = placeable.spec_husbandryPallets;
									if spec ~= nil then
										local spawner = spec.fillTypeIndexToPalletSpawner[fillTypeIndex];
										if spawner ~= nil then
											spawner:getAllPallets(fillTypeIndex, self.getAllPalletsCallback, self);
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	return 0;
end;

function automaticMilkSale:getAllPalletsCallback(pallets, fillTypeIndex)
	for _, pallet in pairs(pallets) do
		local fillUnitIndex = pallet.spec_pallet.fillUnitIndex;
		local fillLevel = pallet:getFillUnitFillLevel(fillUnitIndex);
		local _price = fillLevel * g_currentMission.economyManager:getPricePerLiter(fillTypeIndex);
		g_currentMission:addMoney(_price, pallet:getOwnerFarmId(), MoneyType.SOLD_MILK, true, true);
		pallet:delete();
	end;
end;


function automaticMilkSale:hourChanged()
	local currentHour = g_currentMission.environment.currentHour

	if currentHour == 6 then
		self:sellMilk();
	end;
end;

addModEventListener(automaticMilkSale);