-- Copyright 2024 by Todd Hundersmarck (ThundR)
-- All Rights Reserved

local thModName = g_currentModName
local thModPath = g_currentModDirectory
source(thModPath .. "scripts/utilities/THUtils.lua")
source(thModPath .. "scripts/managers/THModManager.lua")
source(thModPath .. "scripts/managers/THSpecManager.lua")
THPlaceableDesignKit = {}
local THPlaceableDesignKit_mt = THUtils.createClass(THPlaceableDesignKit)
THPlaceableDesignKit.DATA_KEY = "thPlaceableDesign"
function THPlaceableDesignKit.new(customMt)
    customMt = customMt or THPlaceableDesignKit_mt
    if THUtils.argIsValid(type(customMt) == "table", "customMt", customMt) then
        local self = setmetatable({}, customMt)
        self.isServer = g_server ~= nil
        self.isClient = g_client ~= nil
        self.modName = thModName
        self.modPath = thModPath
        self.dataKey = THPlaceableDesignKit.DATA_KEY
        self.thModManager = g_thModManager
        self.thSpecManager = g_thSpecManager
        self.i18n = g_i18n
        return self
    end
end
THUtils.call(function()
    local thMain = THPlaceableDesignKit.new()
    if thMain ~= nil then
        _G.g_thPlaceableDesignKit = thMain
        local thSpecManager = thMain.thSpecManager
        if THGameVersion == 25 then
            thSpecManager:addSpecialization(THSpecType.PLACEABLE, thMain.dataKey, "THPlaceableDesignSpec", thMain.modName, "scripts/placeables/specializations/THPlaceableDesignSpec.lua")
        end
    end
end)