-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

local thMain = g_thDefaultTypes
THPlaceableHusbandryMeadow = {}
function THPlaceableHusbandryMeadow.gInj_onPostLoad(superFunc, placeable, ...)
    local husbandryMeadowSpec = placeable.spec_husbandryMeadow
    local meadowFillTypes, isFruitTypesTableCreated = nil, false
    if husbandryMeadowSpec ~= nil then
        THUtils.call(function()
            if husbandryMeadowSpec.fruitTypes == nil
                and type(husbandryMeadowSpec.fruitTypeInfos) == "table"
            then
                husbandryMeadowSpec.fruitTypes = husbandryMeadowSpec.fruitTypeInfos
                isFruitTypesTableCreated = true
                meadowFillTypes = {}
                for _, infoEntry in pairs(husbandryMeadowSpec.fruitTypeInfos) do
                    if infoEntry.fillTypeIndex ~= nil and infoEntry.fillTypeIndex ~= FillType.UNKNOWN then
                        meadowFillTypes[infoEntry.fillTypeIndex] = true
                    end
                end
            end
        end)
    end
    local function appendFunc(...)
        if husbandryMeadowSpec ~= nil and isFruitTypesTableCreated then
            THUtils.call(function()
                husbandryMeadowSpec.fruitTypes = nil
                if meadowFillTypes ~= nil then
                    local isWarningShown = false
                    for otherFillType in pairs(meadowFillTypes) do
                        local isFillTypeFound = false
                        for _, infoEntry in pairs(husbandryMeadowSpec.fruitTypeInfos) do
                            if otherFillType == infoEntry.fillTypeIndex then
                                isFillTypeFound = true
                                break
                            end
                        end
                        if not isFillTypeFound then
                            local fillTypeDesc = g_fillTypeManager:getFillTypeByIndex(otherFillType)
                            if not isWarningShown then
                                THUtils.errorMsg(false, placeable.configFileName)
                                isWarningShown = true
                            end
                            if fillTypeDesc == nil or fillTypeDesc.index == FillType.UNKNOWN then
                                THUtils.displayMsg("- missing husbandry meadow fillType")
                            else
                                THUtils.displayMsg("- husbandry meadow fillType %q not supported by animal", fillTypeDesc.name)
                            end
                        end
                    end
                end
            end)
        end
        return ...
    end
    return appendFunc(superFunc(placeable, ...))
end
if thMain ~= nil then
    THUtils.call(function()
        THUtils.setFunctionHook("PlaceableHusbandryMeadow", "onPostLoad", false, false, nil, THPlaceableHusbandryMeadow.gInj_onPostLoad)
    end)
end