-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

local thModName = g_currentModName
local thModPath = g_currentModDirectory
source(thModPath .. "scripts/utilities/THUtils.lua")
THBugFixer = {}
local THBugFixer_mt = THUtils.createClass(THBugFixer)
local function initScript()
    THUtils.call(function()
        local self = THBugFixer.new()
        if self ~= nil then
            THUtils.setFunctionHook("PlaceableSilo", "onFinalizePlacement", false, false, self, THBugFixer.inj_placeableSiloOnFinalizePlacement)
            THUtils.setFunctionHook("PlaceableSilo", "onDelete", false, false, self, THBugFixer.inj_placeableSiloOnDelete)
        end
    end)
end
function THBugFixer.new(customMt)
    customMt = customMt or THBugFixer_mt
    if THUtils.argIsValid(type(customMt) == "table", "customMt", customMt) then
        local self = setmetatable({}, customMt)
        self.isServer = g_server ~= nil
        self.isClient = g_client ~= nil
        self.modName = thModName
        self.modPath = thModPath
        return self
    end
end
function THBugFixer.inj_placeableSiloOnFinalizePlacement(self, superFunc, placeable, ...)
    local siloSpec = placeable.spec_silo
    local function appendFunc(...)
        if g_currentMission ~= nil and siloSpec ~= nil then
            THUtils.call(function()
                local storageSystem = g_currentMission.storageSystem
                local storagesArray = siloSpec.storages
                local ownerFarmId = placeable:getOwnerFarmId()
                if storagesArray ~= nil and storageSystem ~= nil then
                    for _, storage in ipairs(storagesArray) do
                        if storage.isExtension then
                            local extendableUnloadingStations = storageSystem:getExtendableUnloadingStationsInRange(storage, ownerFarmId)
                            local extendableLoadingStations = storageSystem:getExtendableLoadingStationsInRange(storage, ownerFarmId)
                            if extendableUnloadingStations ~= nil then
                                for _, station in pairs(extendableUnloadingStations) do
                                    if station ~= siloSpec.unloadingStation then
                                        storageSystem:addStorageToUnloadingStation(storage, station)
                                    end
                                end
                            end
                            if extendableLoadingStations ~= nil then
                                for _, station in pairs(extendableLoadingStations) do
                                    if station ~= siloSpec.loadingStation then
                                        storageSystem:addStorageToLoadingStation(storage, station)
                                    end
                                end
                            end
                        end
                    end
                end
            end)
        end
        return ...
    end
    return appendFunc(superFunc(placeable, ...))
end
function THBugFixer.inj_placeableSiloOnDelete(self, superFunc, placeable, ...)
    local siloSpec = placeable.spec_silo
    if g_currentMission ~= nil and siloSpec ~= nil then
        THUtils.call(function()
            local storageSystem = g_currentMission.storageSystem
            local storagesArray = siloSpec.storages
            if storagesArray ~= nil and storageSystem ~= nil then
                local externalStations = {}
                for _, storage in pairs(storagesArray) do
                    if storage.unloadingStations ~= nil then
                        for _, station in pairs(storage.unloadingStations) do
                            if station ~= siloSpec.unloadingStation then
                                externalStations[station] = station
                            end
                        end
                        storageSystem:removeStorageFromUnloadingStations(storage, externalStations)
                    end
                    THUtils.clearTable(externalStations)
                    if storage.loadingStations ~= nil then
                        for _, station in pairs(storage.loadingStations) do
                            if station ~= siloSpec.loadingStation then
                                externalStations[station] = station
                            end
                        end
                        storageSystem:removeStorageFromLoadingStations(storage, externalStations)
                    end
                end
            end
        end)
    end
    return superFunc(placeable, ...)
end
initScript()