--[[
Name: Def Pack
Copyright (C) Levis, 2025
Author: Levis
All Rights Reserved
Date: 03.04.2025
Version: 1.0.0.2
]]

--[[
-- Important:
-- Not to be added to any mods / maps or modified from its current release form.
-- No modifications may be made to this script without written permission from Levis.

-- Wichtig:
-- Darf nicht zu Mods / Karten hinzugefügt oder in seiner aktuellen Veröffentlichungsform geändert werden.
-- Änderungen an diesem Skript dürfen nur mit schriftlicher Genehmigung von Levis vorgenommen werden.

-- Fontos:
-- Nem adható hozzá semmilyen modhoz / térképhez, és nem módosítható az aktuális kiadási formájában.
-- A szkript módosítása csak Levis írásos engedélyével történhet.

-- Important :
-- Ne doit pas être ajouté à des mods / cartes ou modifié sous sa forme de publication actuelle.
-- Aucune modification ne peut être apportée à ce script sans l'autorisation écrite de Levis.

-- Importante:
-- No debe añadirse a ningún mod / mapa ni modificarse desde su versión actual.
-- No se pueden hacer modificaciones a este script sin el permiso por escrito de Levis.

-- Önemli:
-- Hiçbir moda / haritaya eklenemez veya mevcut yayınlanan halinden değiştirilemez.
-- Bu betikte Levis'in yazılı izni olmadan değişiklik yapılamaz.

-- Ważne:
-- Nie może być dodawany do żadnych modów / map ani modyfikowany w swojej obecnej formie.
-- Żadne zmiany nie mogą być dokonywane w tym skrypcie bez pisemnej zgody Levisa.

-- Importante:
-- Non deve essere aggiunto a nessuna mod / mappa né modificato rispetto alla versione attuale.
-- Nessuna modifica può essere apportata a questo script senza il permesso scritto di Levis.

-- Importante:
-- Não deve ser adicionado a nenhum mod / mapa nem modificado em sua versão atual.
-- Nenhuma modificação pode ser feita neste script sem permissão por escrito de Levis.

-- Vigtigt:
-- Må ikke tilføjes til nogen mods / kort eller ændres fra den nuværende udgivelsesform.
-- Ingen ændringer må foretages i dette script uden skriftlig tilladelse fra Levis.

-- Viktig:
-- Skal ikke legges til i noen mods / kart eller endres fra sin nåværende utgivelsesform.
-- Ingen endringer kan gjøres i dette skriptet uten skriftlig tillatelse fra Levis.

-- Viktigt:
-- Får inte läggas till i några mods / kartor eller ändras från sin nuvarande version.
-- Inga ändringar får göras i detta skript utan skriftligt tillstånd från Levis.

-- 重要:
-- このスクリプトは、いかなるModやマップにも追加したり、現在のリリース形態から変更したりすることはできません。
-- Levis の書面による許可なしに、このスクリプトを変更することはできません。

-- Důležité:
-- Nesmí být přidáno do žádných modů / map ani upraveno z aktuální verze.
-- Žádné úpravy tohoto skriptu nejsou povoleny bez písemného souhlasu Levis.
]]

MyDEFLoader = {} MyDEFLoader.done = false MyDEFLoader.logTimer = 0 MyDEFLoader.attemptDelay = 5000 local LOGGING_ENABLED = false function infoPrint(text, ...) if LOGGING_ENABLED then print("Def Pack >> " .. text, ...) end end infoPrint("DEFLoader: Script loaded") source(g_currentModDirectory .. "scripts/DEFUtil.lua") local function isRealVehicle(xmlFile, vehicleKey) local motorized = getXMLBool(xmlFile, vehicleKey .. "#motorized") if motorized ~= nil then return motorized end local j = 0 while hasXMLProperty(xmlFile, vehicleKey .. ".fillUnit.unit(" .. j .. ")") do local fillType = getXMLString(xmlFile, vehicleKey .. ".fillUnit.unit(" .. j .. ")#fillType") if fillType and string.upper(fillType) == "DIESEL" then return true end j = j + 1 end return false end local function getRawDEFLevelFromVehicleNode(xmlFile, vehicleKey) local j = 0 while hasXMLProperty(xmlFile, vehicleKey .. ".fillUnit.unit(" .. j .. ")") do local unitKey = vehicleKey .. ".fillUnit.unit(" .. j .. ")" local fillType = getXMLString(xmlFile, unitKey .. "#fillType") if fillType and string.upper(fillType) == "DEF" then return getXMLFloat(xmlFile, unitKey .. "#fillLevel") end j = j + 1 end return nil end function MyDEFLoader:loadDEFLevels() infoPrint("DEFLoader: loadDEFLevels() called") local missionInfo = g_currentMission.missionInfo if not missionInfo or not missionInfo.savegameDirectory then infoPrint("DEFLoader: Savegame directory not available") return false end local saveDir = missionInfo.savegameDirectory local vehiclesXMLPath = saveDir .. "/vehicles.xml" infoPrint("DEFLoader: Loading vehicles.xml from: " .. vehiclesXMLPath) local xmlFile = loadXMLFile("vehicles", vehiclesXMLPath) if not xmlFile then infoPrint("DEFLoader: Failed to load vehicles.xml") return false end local i = 0 local numUpdated = 0 while hasXMLProperty(xmlFile, "vehicles.vehicle(" .. i .. ")") do local vehicleKey = "vehicles.vehicle(" .. i .. ")" local xmlUniqueId = getXMLString(xmlFile, vehicleKey .. "#uniqueId") if xmlUniqueId then if not isRealVehicle(xmlFile, vehicleKey) then else local rawDEF = getRawDEFLevelFromVehicleNode(xmlFile, vehicleKey) if rawDEF then local found = false if g_currentMission.vehicleSystem and g_currentMission.vehicleSystem.vehicles then for _, vehicle in ipairs(g_currentMission.vehicleSystem.vehicles) do local vehUniqueId = vehicle:getUniqueId() if vehUniqueId and vehUniqueId == xmlUniqueId then local defFillUnitIndex = vehicle:getConsumerFillUnitIndex(FillType.DEF) if defFillUnitIndex then if vehicle.setFillUnitFillLevel and type(vehicle.setFillUnitFillLevel) == "function" then vehicle:setFillUnitFillLevel(defFillUnitIndex, rawDEF) else if vehicle.spec_fillUnit and vehicle.spec_fillUnit.fillUnits and vehicle.spec_fillUnit.fillUnits[defFillUnitIndex] then vehicle.spec_fillUnit.fillUnits[defFillUnitIndex].fillLevel = rawDEF if vehicle.spec_fillUnit.dirtyFlag then vehicle:raiseDirtyFlags(vehicle.spec_fillUnit.dirtyFlag) end else infoPrint("DEFLoader: Unable to update DEF level for vehicle " .. tostring(vehicle:getFullName())) end end infoPrint("DEFLoader: Updated vehicle " .. tostring(vehicle:getFullName()) .. " (uniqueId=" .. tostring(vehUniqueId) .. ") to raw DEF level: " .. tostring(rawDEF)) numUpdated = numUpdated + 1 found = true break end end end end if not found then infoPrint("DEFLoader: No matching in‑memory vehicle found for XML uniqueId: " .. tostring(xmlUniqueId)) end end end else infoPrint("DEFLoader: Vehicle node " .. tostring(i) .. " has no uniqueId attribute") end i = i + 1 end infoPrint("DEFLoader: Finished updating DEF levels. Total vehicles updated: " .. tostring(numUpdated)) delete(xmlFile) return (numUpdated > 0) end if g_currentModName ~= "FS25_Lev_DefPack" then return end function MyDEFLoader:update(dt) local missionInfo = g_currentMission and g_currentMission.missionInfo if missionInfo and missionInfo.isMultiplayer then infoPrint("DEFLoader: Multiplayer mode detected, script disabled.") removeModEventListener(MyDEFLoader) return end if g_currentMission.getIsServer and not g_currentMission:getIsServer() then infoPrint("DEFLoader: Multiplayer client detected, script disabled.") removeModEventListener(MyDEFLoader) return end if not g_currentMission or not missionInfo or not missionInfo.savegameDirectory then return end if not g_currentMission.vehicleSystem or not g_currentMission.vehicleSystem.vehicles or #g_currentMission.vehicleSystem.vehicles == 0 then return end if not self.done then local success = self:loadDEFLevels() if success then self.done = true infoPrint("DEFLoader: Script run completed. Removing event listener.") removeModEventListener(MyDEFLoader) else self.logTimer = (self.logTimer or 0) + dt if self.logTimer >= self.attemptDelay then infoPrint("DEFLoader: Re‑attempting to load DEF levels...") self:loadDEFLevels() self.logTimer = 0 end end end end addModEventListener(MyDEFLoader)
