-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

--[[

Unauthorized use and/or distribution of this work entitles
myself, the author, to unlimited free and unrestricted use,
access, and distribution of any works related to the unauthorized
user and/or distributor.

--]]

THFieldMissions = {}
local THFieldMissions_mt = Class(THFieldMissions)
THFieldMissions.CLASS_NAME = "THFieldMissions"
THFieldMissions.DATA_KEY = tostring(THFieldMissions)
local debugFlagId = THUtils.createDebugFlagId(THFieldMissions.CLASS_NAME)
THFieldMissions.debugFlagId = debugFlagId
local function getCustomData(self)
    return THUtils.call(function()
        return THUtils.getDataTable(self, THFieldMissions.DATA_KEY)
    end)
end
THFieldMissions.getCustomData = getCustomData
local function initScript()
    g_thEventManager:addDelayedLoadTask(function()
        THUtils.overwriteFunction("SowMission", "getPartitionCompletion", false, false, nil, THFieldMissions.gOverwrite_sowMissionGetPartitionCompletion)
        THUtils.appendFunction("HarvestMission", "initializeModifier", false, false, nil, THFieldMissions.gAppend_harvestMissionInitializeModifier)
        THUtils.overwriteFunction("HarvestMission", "getPartitionCompletion", false, false, nil, THFieldMissions.gOverwrite_harvestMissionGetPartitionCompletion)
    end)
end
function THFieldMissions.new(parent, customMt)
    customMt = customMt or THFieldMissions_mt
    if THUtils.argIsValid(THUtils.getIsType(parent, AbstractFieldMission), "parent", parent)
        and THUtils.argIsValid(type(customMt) == THValueType.TABLE, "customMt", customMt)
    then
        local self = getCustomData(parent)
        if self == nil then
            self = THUtils.createDataTable(parent, THFieldMissions.DATA_KEY, customMt)
        end
        return self
    end
end
function THFieldMissions.gOverwrite_sowMissionGetPartitionCompletion(superFunc, parent, partitionIndex, ...)
    local function appendFunc(rSumPixels, rChangedArea, rTotalArea, ...)
        if partitionIndex ~= nil
            and type(rChangedArea) == THValueType.NUMBER and rChangedArea > 0
            and type(rTotalArea) == THValueType.NUMBER and rTotalArea > 0
        then
            THUtils.pcall(function()
                local self = getCustomData(parent)
                if self == nil then
                    self = THFieldMissions.new(parent)
                end
                if self ~= nil then
                    self.completionFactor = 1
                    local fruitMetersPerPixel = g_thMapTypeManager:getFruitMetersPerPixel()
                    local spacingValues = g_thRowCropSystem:getFruitTypeRowSpacing(parent.fruitTypeIndex)
                    local isDebugUpdateEnabled = THUtils.getIsDebugEnabled(debugFlagId, THDebugLevel.UPDATE)
                    if spacingValues ~= nil then
                        local rcsFruitData = spacingValues.fruitType
                        local popFactorWidth = math.max(fruitMetersPerPixel, spacingValues.spacingWidth or 0)
                        local popFactorLength = math.max(fruitMetersPerPixel, spacingValues.spacingLength or 0)
                        self.completionFactor = math.max(0, (popFactorWidth / fruitMetersPerPixel) * (popFactorLength / fruitMetersPerPixel))
                        if self.completionFactor ~= 1 then
                            if isDebugUpdateEnabled then
                                THUtils.displayMsg("SowMission.getPartitionCompletionArea: %s (%s)", rcsFruitData.fruitType.name, rcsFruitData.fruitType.index)
                                THUtils.displayMsg("- sumPixels (before): %s", rSumPixels)
                                THUtils.displayMsg("- changedArea (before): %s", rChangedArea)
                                THUtils.displayMsg("- totalArea (before): %s", rTotalArea)
                                THUtils.displayMsg("")
                            end
                            rChangedArea = math.min(rTotalArea, rChangedArea * self.completionFactor)
                            if type(rSumPixels) == THValueType.NUMBER and rSumPixels > 0 then
                                rSumPixels = math.min(rTotalArea, rSumPixels * self.completionFactor)
                            end
                            if isDebugUpdateEnabled then
                                THUtils.displayMsg("- sumPixels (after): %s", rSumPixels)
                                THUtils.displayMsg("- changedArea (after): %s", rChangedArea)
                                THUtils.displayMsg("- totalArea (after): %s", rTotalArea)
                                THUtils.displayMsg("- completionFactor: %s", self.completionFactor)
                                THUtils.displayMsg("")
                            end
                        end
                    end
                end
            end)
        end
        return rSumPixels, rChangedArea, rTotalArea, ...
    end
    return appendFunc(superFunc(parent, partitionIndex, ...))
end
function THFieldMissions.gAppend_harvestMissionInitializeModifier(superFunc, parent, ...)
    local self = getCustomData(parent)
    local terrainNode = g_terrainNode
    local fieldInfo = parent.field
    local infoLayerData = g_thRowCropSystem.infoLayers
    local rcsFruitData = g_thRowCropSystem:getRowCropFruitType(parent.fruitTypeIndex)
    if self == nil then
        self = THFieldMissions.new(parent)
        if self ~= nil then
            self.dmFruitModifiers = {}
            self.dmFruitFilters = {}
        end
    end
    if self ~= nil then
        self.completionFactor = 1
        if rcsFruitData ~= nil and infoLayerData.isValid
            and terrainNode ~= nil and fieldInfo ~= nil
        then
            local dmPolygon = fieldInfo:getDensityMapPolygon()
            if dmPolygon ~= nil then
                local dmFruitModifier = self.dmFruitModifiers[rcsFruitData.fruitType.index]
                local dmFruitFilter = self.dmFruitFilters[rcsFruitData.fruitType.index]
                local dmFieldFilter = infoLayerData.shared.dmFieldFilter
                if dmFruitModifier == nil or dmFruitFilter == nil then
                    local fruitLayerId = rcsFruitData.fruitType.desc.terrainDataPlaneId
                    local startStateChannel = rcsFruitData.fruitType.desc.startStateChannel
                    local numStateChannels = rcsFruitData.fruitType.desc.numStateChannels
                    if fruitLayerId ~= nil and startStateChannel ~= nil
                        and numStateChannels ~= nil and numStateChannels > 0
                    then
                        dmFruitModifier = DensityMapModifier.new(fruitLayerId, startStateChannel, numStateChannels, terrainNode)
                        dmFruitFilter = DensityMapFilter.new(fruitLayerId, startStateChannel, numStateChannels, terrainNode)
                        local minHarvestState = rcsFruitData.fruitType.minForageState
                        if minHarvestState == nil or minHarvestState <= 0 then
                            minHarvestState = rcsFruitData.fruitType.minHarvestState
                        end
                        if minHarvestState ~= nil and minHarvestState > 0 then
                            dmFruitFilter:setValueCompareParams(DensityValueCompareType.GREATER, minHarvestState - 1)
                        else
                            dmFruitFilter:setValueCompareParams(DensityValueCompareType.GREATER, 0)
                        end
                        self.dmFruitModifiers[rcsFruitData.fruitType.index] = dmFruitModifier
                        self.dmFruitFilters[rcsFruitData.fruitType.index] = dmFruitFilter
                    end
                end
                if dmFruitModifier ~= nil and dmFruitFilter ~= nil then
                    dmPolygon:applyToModifier(dmFruitModifier)
                    local sumPixels, changedArea, totalArea = dmFruitModifier:executeGet(dmFruitFilter, dmFieldFilter)
                    if sumPixels ~= nil and sumPixels > 0
                        and totalArea ~= nil and totalArea > 0
                    then
                        local fieldDoneFactor = THUtils.clamp(parent.fieldPercentageDone or 0, 0, 1)
                        local coverageFactor = THUtils.clamp(sumPixels / totalArea, 0, 1)
                        coverageFactor = fieldDoneFactor + (coverageFactor * (1 - fieldDoneFactor))
                        if coverageFactor > 0 then
                            self.completionFactor = 1 / coverageFactor
                            if THUtils.getIsDebugEnabled(debugFlagId) then
                                THUtils.displayMsg("HarvestMission - initializeModifier: %s (%s)", rcsFruitData.fruitType.name, rcsFruitData.fruitType.index)
                                THUtils.displayMsg("- sumPixels: %s", sumPixels)
                                THUtils.displayMsg("- changedArea: %s", changedArea)
                                THUtils.displayMsg("- totalArea: %s", totalArea)
                                THUtils.displayMsg("- coverageFactor: %s", coverageFactor)
                                THUtils.displayMsg("- completionFactor: %s", self.completionFactor)
                                THUtils.displayMsg("")
                            end
                        end
                    end
                end
            end
        end
    end
end
function THFieldMissions.gOverwrite_harvestMissionGetPartitionCompletion(superFunc, parent, partitionIndex, ...)
    local self = getCustomData(parent)
    local terrainNode = g_terrainNode
    local function appendFunc(rSumPixels, rChangedArea, rTotalArea, ...)
        if self ~= nil and terrainNode ~= nil and partitionIndex ~= nil
            and type(rChangedArea) == THValueType.NUMBER and rChangedArea > 0
            and type(rTotalArea) == THValueType.NUMBER and rTotalArea > 0
        then
            THUtils.pcall(function()
                if self.completionFactor ~= 1 then
                    local isDebugUpdateEnabled = THUtils.getIsDebugEnabled(debugFlagId, THDebugLevel.UPDATE)
                    if isDebugUpdateEnabled then
                        THUtils.displayMsg("HarvestMission.getPartitionCompletionArea:")
                        THUtils.displayMsg("- sumPixels (before): %s", rSumPixels)
                        THUtils.displayMsg("- changedArea (before): %s", rChangedArea)
                        THUtils.displayMsg("- totalArea (before): %s", rTotalArea)
                        THUtils.displayMsg("")
                    end
                    rChangedArea = math.min(rTotalArea, rChangedArea * self.completionFactor)
                    if type(rSumPixels) == THValueType.NUMBER and rSumPixels > 0 then
                        rSumPixels = math.min(rTotalArea, rSumPixels * self.completionFactor)
                    end
                    if isDebugUpdateEnabled then
                        THUtils.displayMsg("- sumPixels (after): %s", rSumPixels)
                        THUtils.displayMsg("- changedArea (after): %s", rChangedArea)
                        THUtils.displayMsg("- totalArea (after): %s", rTotalArea)
                        THUtils.displayMsg("- completionFactor: %s", self.completionFactor)
                        THUtils.displayMsg("")
                    end
                end
            end)
        end
        return rSumPixels, rChangedArea, rTotalArea, ...
    end
    return appendFunc(superFunc(parent, partitionIndex, ...))
end
THUtils.pcall(initScript)