--[[
	Author: 	Ifko[nator]
	Date:		28.06.2025
	Version:	1.0
	
	History:	v1.0 @28.06.2025 - initial implementation in FS 25
]]

ToggleableSilageAdditiveEvent = {};

ToggleableSilageAdditiveEvent_mt = Class(ToggleableSilageAdditiveEvent, Event);

InitEventClass(ToggleableSilageAdditiveEvent, "ToggleableSilageAdditiveEvent");

function ToggleableSilageAdditiveEvent.emptyNew()
	local self = Event.new(ToggleableSilageAdditiveEvent_mt);
    
	return self;
end;

function ToggleableSilageAdditiveEvent.new(trailer, isActive)
	local self = ToggleableSilageAdditiveEvent.emptyNew();
	
	self.trailer = trailer;
	self.isActive = isActive;
	
	return self;
end;

function ToggleableSilageAdditiveEvent:readStream(streamId, connection)
	self.trailer = NetworkUtil.readNodeObject(streamId);
	self.isActive = streamReadBool(streamId);
	
    self:run(connection);
end;

function ToggleableSilageAdditiveEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.trailer);
	
	streamWriteBool(streamId, self.isActive);
end;

function ToggleableSilageAdditiveEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(ToggleableSilageAdditiveEvent.new(self.trailer, self.isActive), nil, connection, self.trailer);
	end;
	
    if self.trailer ~= nil and self.trailer.setSilageAdditiveUsage ~= nil then
        self.trailer:setSilageAdditiveUsage(self.isActive, true);
	end;
end;