--[[
	ToggleableSilageAdditive.lua
	
	Autor: 		Ifko[nator]
	Datum: 		29.06.2025
	Version: 	1.0
	
	Changelog:	v1.0 @29.06.2025 - initial implementation in FS 25
]]

ToggleableSilageAdditive = {};

ToggleableSilageAdditive.currentModName = "";

for _, mod in pairs(g_modManager.mods) do
	if mod.title:upper() == "UMSCHALTBARE SILIERMITTEL NUTZUNG" or mod.title:upper() == "TOGGLEABLE SILAGE ADDITIVE" then		
		if g_modIsLoaded[mod.modName] then	
			ToggleableSilageAdditive.currentModName = mod.modName;

			break;
		end;
	end;
end;

local function getSpecByName(self, specName, currentModName)
	local spec = self["spec_" .. Utils.getNoNil(currentModName, ToggleableSilageAdditive.currentModName) .. "." .. specName];

	if spec ~= nil then
        return spec;
    end;

    return self["spec_" .. specName];
end;

function ToggleableSilageAdditive.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(ForageWagon, specializations) or SpecializationUtil.hasSpecialization(Baler, specializations) or SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function ToggleableSilageAdditive.initSpecialization()
	local schemaSavegame = Vehicle.xmlSchemaSavegame;

	schemaSavegame:register(XMLValueType.BOOL, "vehicles.vehicle(?).toggleableSilageAdditive#isActive", "Is silage additive usage active. (true/false)", false);
end;

function ToggleableSilageAdditive.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad",
		"onUpdate",
		"onRegisterActionEvents"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, ToggleableSilageAdditive);
	end;
end;

function ToggleableSilageAdditive.registerFunctions(vehicleType)
	local newFunctions = {
		"setSilageAdditiveUsage"
	};
	
	for _, newFunction in ipairs(newFunctions) do
		SpecializationUtil.registerFunction(vehicleType, newFunction, ToggleableSilageAdditive[newFunction]);
	end;
end;

function ToggleableSilageAdditive:onLoad(savegame)
	self.spec_toggleableSilageAdditive = getSpecByName(self, "toggleableSilageAdditive");

	local specToggleableSilageAdditive = self.spec_toggleableSilageAdditive;
	local specForageWagon = self.spec_forageWagon;
	local specBaler = self.spec_baler;
	local specCombine = self.spec_combine;

	specToggleableSilageAdditive.isActive = true;
	specToggleableSilageAdditive.isAvailable = false;

	specToggleableSilageAdditive.l10nTexts = {};

	local l10nTexts = {
		"DEACTIVATE_SILAGE_ADDITIVE_USAGE",
		"ACTIVATE_SILAGE_ADDITIVE_USAGE"
	};
	
	for _, l10nText in pairs(l10nTexts) do
		specToggleableSilageAdditive.l10nTexts[l10nText] = g_i18n:getText(l10nText, ToggleableSilageAdditive.currentModName);
	end;

	local additivesFillUnitIndex = nil;
		
	if specForageWagon ~= nil then
		additivesFillUnitIndex = specForageWagon.additives.fillUnitIndex;

	elseif specBaler ~= nil then
		additivesFillUnitIndex = specBaler.additives.fillUnitIndex;

	elseif specCombine ~= nil then
		additivesFillUnitIndex = specCombine.additives.fillUnitIndex;
	end;
	
	if additivesFillUnitIndex ~= nil then
		specToggleableSilageAdditive.isAvailable = self:getFillUnitByIndex(additivesFillUnitIndex) ~= nil;
	
		if savegame ~= nil then 
			specToggleableSilageAdditive.isActive = savegame.xmlFile:getValue(savegame.key .. ".toggleableSilageAdditive#isActive", specToggleableSilageAdditive.isActive);
		end;

		self:setSilageAdditiveUsage(specToggleableSilageAdditive.isActive, false);
	end;
end;

function ToggleableSilageAdditive:onWriteStream(streamId, connection)
	if not connection:getIsServer() then
		local specToggleableSilageAdditive = self.spec_toggleableSilageAdditive;
		
		if specToggleableSilageAdditive.isAvailable then
			streamWriteBool(streamId, specToggleableSilageAdditive.isActive);
		end;
	end;
end;

function ToggleableSilageAdditive:onReadStream(streamId, connection)
	if connection:getIsServer() then
		local specToggleableSilageAdditive = self.spec_toggleableSilageAdditive;
		
		if specToggleableSilageAdditive.isAvailable then
			specToggleableSilageAdditive.isActive = streamReadBool(streamId);
			
			self:setSilageAdditiveUsage(specToggleableSilageAdditive.isActive, true);
		end;
	end;
end;

function ToggleableSilageAdditive:onRegisterActionEvents(isActiveForInput)
	local specToggleableSilageAdditive = self.spec_toggleableSilageAdditive;
	
	if self.isClient and specToggleableSilageAdditive.isAvailable then        
		self:clearActionEventsTable(specToggleableSilageAdditive.actionEvents);
        
		if self:getIsActiveForInput(true) then
            local _, actionEventId = self:addActionEvent(specToggleableSilageAdditive.actionEvents, InputAction.TOGGLE_SILAGE_ADDITIVE_USAGE_BUTTON, self, ToggleableSilageAdditive.toggleSilageAdditiveUsage, false, true, false, true, nil);
			
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_NORMAL);
			g_inputBinding:setActionEventTextVisibility(actionEventId, true);
			g_inputBinding:setActionEventActive(actionEventId, false);
		end;
	end;
end;

function ToggleableSilageAdditive.toggleSilageAdditiveUsage(self, actionName, inputValue, callbackState, isAnalog)
	self:setSilageAdditiveUsage(not self.spec_toggleableSilageAdditive.isActive, false);
end;

function ToggleableSilageAdditive:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local specToggleableSilageAdditive = self.spec_toggleableSilageAdditive;
	local specForageWagon = self.spec_forageWagon;
	local specBaler = self.spec_baler;
	local specCombine = self.spec_combine;

	if self.isClient and specToggleableSilageAdditive.isAvailable then
		local setSilageAdditiveUsageButton = specToggleableSilageAdditive.actionEvents[InputAction.TOGGLE_SILAGE_ADDITIVE_USAGE_BUTTON];
		local fillUnitIndex = nil;

		if specForageWagon ~= nil then
			specForageWagon.additives.available = specToggleableSilageAdditive.isActive;

			fillUnitIndex = specForageWagon.additives.fillUnitIndex;
			
		elseif specBaler ~= nil then
			specBaler.additives.available = specToggleableSilageAdditive.isActive;

			fillUnitIndex = specBaler.additives.fillUnitIndex;
		
		elseif specCombine ~= nil then
			specCombine.additives.available = specToggleableSilageAdditive.isActive;

			fillUnitIndex = specCombine.additives.fillUnitIndex;
		end;
		
		if setSilageAdditiveUsageButton ~= nil and fillUnitIndex ~= nil then
			local currentText = specToggleableSilageAdditive.l10nTexts.DEACTIVATE_SILAGE_ADDITIVE_USAGE;

			g_inputBinding:setActionEventActive(setSilageAdditiveUsageButton.actionEventId, self:getFillUnitFillLevel(fillUnitIndex) > 0);

			if not specToggleableSilageAdditive.isActive then
				currentText = specToggleableSilageAdditive.l10nTexts.ACTIVATE_SILAGE_ADDITIVE_USAGE;
			end;

			g_inputBinding:setActionEventText(setSilageAdditiveUsageButton.actionEventId, currentText);
		end;
	end;
end;

function ToggleableSilageAdditive:saveToXMLFile(xmlFile, key, usedModNames)
	local specToggleableSilageAdditive = self.spec_toggleableSilageAdditive;
	
	if specToggleableSilageAdditive.isAvailable then
		xmlFile:setValue(key .. "#isActive", specToggleableSilageAdditive.isActive);
	end;
end;

function ToggleableSilageAdditive:setSilageAdditiveUsage(isActive, noEventSend)
	local specToggleableSilageAdditive = self.spec_toggleableSilageAdditive;
	
	if isActive ~= specToggleableSilageAdditive.isActive then
		specToggleableSilageAdditive.isActive = isActive;
		
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(ToggleableSilageAdditiveEvent.new(self, isActive), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(ToggleableSilageAdditiveEvent.new(self, isActive));
			end;
		end;
	end;
end;