
extendedFarmsiloShopDisplay = {}

function extendedFarmsiloShopDisplay.PlaceableSiloExtensionInitSpecialization()
	g_storeManager:addSpecType("siloExtensionFillTypes", "shopListAttributeIconInput", PlaceableSiloExtension.loadSpecValueInputFillTypes, PlaceableSiloExtension.getSpecValueInputFillTypes, StoreSpecies.PLACEABLE)
	g_storeManager:addSpecType("siloExtensionVolume", "shopListAttributeIconCapacity", PlaceableSiloExtension.loadSpecValueVolume, PlaceableSiloExtension.getSpecValueVolume, StoreSpecies.PLACEABLE)
end
function extendedFarmsiloShopDisplay.PlaceableSiloInitSpecialization()
	g_storeManager:addSpecType("siloFillTypes", "shopListAttributeIconInput", PlaceableSilo.loadSpecValueInputFillTypes, PlaceableSilo.getSpecValueInputFillTypes, StoreSpecies.PLACEABLE)
	g_storeManager:addSpecType("siloVolume", "shopListAttributeIconCapacity", PlaceableSilo.loadSpecValueVolume, PlaceableSilo.getSpecValueVolume, StoreSpecies.PLACEABLE)
end

function extendedFarmsiloShopDisplay.PlaceableSiloExtensionLoadSpecValueInputFillTypes(xmlFile, customEnvironment, baseDir)
	local fillTypeNamesString = nil
	local fillTypeCategoryNamesString = nil
	local filltypesReturn = nil

	fillTypeNamesString = xmlFile:getValue("placeable.siloExtension.storage#fillTypes")
	fillTypeCategoryNamesString = xmlFile:getValue("placeable.siloExtension.storage#fillTypeCategories")
	
	if fillTypeNamesString ~= nil then
		fillTypes = g_fillTypeManager:getFillTypesByNames(fillTypeNamesString)
		filltypesReturn = {}
		for _, filltype in pairs(fillTypes) do
			if filltypesReturn[g_fillTypeManager:getFillTypeNameByIndex(filltype)] == nil then
				filltypesReturn[g_fillTypeManager:getFillTypeNameByIndex(filltype)] = true
			end
		end
	elseif fillTypeCategoryNamesString ~= nil then
		fillTypes = g_fillTypeManager:getFillTypesByCategoryNames(fillTypeCategoryNamesString)
		filltypesReturn = {}
		for _, filltype in pairs(fillTypes) do
			if filltypesReturn[g_fillTypeManager:getFillTypeNameByIndex(filltype)] == nil then
				filltypesReturn[g_fillTypeManager:getFillTypeNameByIndex(filltype)] = true
			end
		end		
	end
	return filltypesReturn
end

function extendedFarmsiloShopDisplay.PlaceableSiloExtensionGetSpecValueInputFillTypes(storeItem, realItem)
	if storeItem.specs ~= nil then
		if storeItem.specs.siloExtensionFillTypes ~= nil then
			return g_fillTypeManager:getFillTypesByNames(table.concatKeys(storeItem.specs.siloExtensionFillTypes, " "))
		else
			return nil
		end
	end
end

function extendedFarmsiloShopDisplay.PlaceableSiloLoadSpecValueInputFillTypes(xmlFile, customEnvironment, baseDir)
	local fillTypeNamesString = nil
	local fillTypeCategoryNamesString = nil
	local filltypesReturn = nil

	fillTypeNamesString = xmlFile:getValue("placeable.silo.storages.storage(0)#fillTypes")
	fillTypeCategoryNamesString = xmlFile:getValue("placeable.silo.storages.storage(0)#fillTypeCategories")

	if fillTypeNamesString ~= nil then
		fillTypes = g_fillTypeManager:getFillTypesByNames(fillTypeNamesString)
		filltypesReturn = {}
		for _, filltype in pairs(fillTypes) do
			if filltypesReturn[g_fillTypeManager:getFillTypeNameByIndex(filltype)] == nil then
				filltypesReturn[g_fillTypeManager:getFillTypeNameByIndex(filltype)] = true
			end
		end
	elseif fillTypeCategoryNamesString ~= nil then
		fillTypes = g_fillTypeManager:getFillTypesByCategoryNames(fillTypeCategoryNamesString)
		filltypesReturn = {}
		for _, filltype in pairs(fillTypes) do
			if filltypesReturn[g_fillTypeManager:getFillTypeNameByIndex(filltype)] == nil then
				filltypesReturn[g_fillTypeManager:getFillTypeNameByIndex(filltype)] = true
			end
		end
	end
	return filltypesReturn
end

function extendedFarmsiloShopDisplay.PlaceableSiloGetSpecValueInputFillTypes(storeItem, realItem)
	if storeItem.specs ~= nil then
		if storeItem.specs.siloFillTypes ~= nil then
			return g_fillTypeManager:getFillTypesByNames(table.concatKeys(storeItem.specs.siloFillTypes, " "))
		else
			return nil
		end
	end
end

function extendedFarmsiloShopDisplay.ShopControllerMakeDisplayItem(self, superFunc, storeItem, realItem, configurations, saleItem)

	StoreItemUtil.loadSpecsFromXML(storeItem)
	
	local attributeIconProfiles = {}
	local attributeValues = {}

	local function addAttribute(profiles, values, profile, value)
		if profile ~= nil and value ~= nil then
			table.insert(profiles, profile)
			table.insert(values, value)
		end
	end

	if configurations == nil then
		configurations = storeItem.defaultConfigurationIds
	end

	local usedSpecs = {
		fillTypes = true,
		seedFillTypes = true,
		animalFoodFillTypes = true,
		prodPointInputFillTypes = true,
		prodPointOutputFillTypes = true,
		sellingStationFillTypes = true,
		objectStorageFillTypes = true,
		siloExtensionFillTypes = true,
		siloFillTypes = true,
		powerConfig = true
	}

	local function addSpecFromVehicle(specName, specDesc, _storeItem, _realItem, _configurations, _saleItem)
		if usedSpecs[specName] == nil then
			if _realItem ~= nil then
				_configurations = _realItem.configurations
			elseif _saleItem ~= nil then
				_configurations = _saleItem.configurations
			end

			if specDesc.getValueFunc ~= nil then
				local value, profile = specDesc.getValueFunc(_storeItem, _realItem, _configurations, _saleItem)

				if value ~= nil then
					addAttribute(attributeIconProfiles, attributeValues, profile or specDesc.profile, value)

					usedSpecs[specName] = true
				end
			end
		end
	end

	local function addSpec(specName)
		local desc = g_storeManager:getSpecTypeByName(specName)

		if desc ~= nil and desc.species == storeItem.species then
			addSpecFromVehicle(specName, desc, storeItem, realItem, configurations, saleItem)

			if storeItem.bundleInfo ~= nil then
				for _, bundleItem in ipairs(storeItem.bundleInfo.bundleItems) do
					if configurations == nil then
						configurations = {}
					end

					for configName, data in pairs(bundleItem.preSelectedConfigurations) do
						configurations[configName] = data.configValue
					end

					addSpecFromVehicle(specName, desc, bundleItem.item, nil, configurations, saleItem)
				end
			end
		end
	end

	addSpec("operatingTime")
	addSpec("power")
	addSpec("transmission")
	addSpec("fuel")
	addSpec("electricCharge")
	addSpec("methane")
	addSpec("maxSpeed")
	addSpec("neededPower")
	addSpec("incomePerHour")
	addSpec("capacity")
	addSpec("weight")
	addSpec("additionalWeight")
	addSpec("wheels")
	addSpec("balerBaleDensity")
	addSpec("balerBaleSizeRound")
	addSpec("balerBaleSizeSquare")
	addSpec("baleWrapperBaleSizeRound")
	addSpec("baleWrapperBaleSizeSquare")
	addSpec("inlineWrapperBaleSizeRound")
	addSpec("inlineWrapperBaleSizeSquare")
	addSpec("baleLoaderBaleSizeRound")
	addSpec("baleLoaderBaleSizeSquare")
	addSpec("woodHarvesterMaxTreeSize")
	addSpec("licensePlate")
	
	if self.currentMission.slotSystem:getAreSlotsVisible() then
		addSpec("slots")
		addSpec("placeableSlots")
	else
		usedSpecs.slots = true
		usedSpecs.placeableSlots = true
	end

	if realItem == nil or realItem.propertyState == Vehicle.PROPERTY_STATE_OWNED or saleItem ~= nil then
		addSpec("dailyUpkeep")
	else
		usedSpecs.dailyUpkeep = true
	end

	if storeItem.lifetime ~= 0 or saleItem ~= nil then
		addSpec("age")
	end

	for _, specDesc in pairs(g_storeManager:getSpecTypes()) do
		if usedSpecs[specDesc.name] == nil then
			addSpec(specDesc.name)
		end
	end

	local fillTypesSpec = g_storeManager:getSpecTypeByName("fillTypes")
	local seedFillTypeSpec = g_storeManager:getSpecTypeByName("seedFillTypes")
	local foodFillTypesSpec = g_storeManager:getSpecTypeByName("animalFoodFillTypes")
	local prodPointInputFillTypesSpec = g_storeManager:getSpecTypeByName("prodPointInputFillTypes")
	local prodPointOutputFillTypesSpec = g_storeManager:getSpecTypeByName("prodPointOutputFillTypes")
	local sellingStationFillTypesSpec = g_storeManager:getSpecTypeByName("sellingStationFillTypes")
	local objectStorageFillTypesSpec = g_storeManager:getSpecTypeByName("objectStorageFillTypes")
	local siloExtensionFillTypesSpec = g_storeManager:getSpecTypeByName("siloExtensionFillTypes")
	local siloFillTypesSpec = g_storeManager:getSpecTypeByName("siloFillTypes")
	local fillTypeIconFilenames, seedTypeIconFilenames, foodFillTypeIconFilenames, prodPointInputFillTypeIconFilenames, prodPointOutputFillTypeIconFilenames, sellingStationFillTypesIconFilenames, objectStorageFillTypesIconFilenames, siloExtensionFillTypesIconFilenames, siloFillTypesIconFilenames = nil

	local function getIconFilenamesForSpec(spec, _storeItem, _realItem, _configurations)
		local iconFilenames = {}

		if spec ~= nil then
			local fillTypeIndicesList = spec.getValueFunc(_storeItem, _realItem, _configurations)

			if fillTypeIndicesList ~= nil then
				for _, fillTypeIndex in pairs(fillTypeIndicesList) do
					local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)

					if fillType ~= nil then
						table.insert(iconFilenames, fillType.hudOverlayFilename)
					end
				end
			end
		end

		return iconFilenames
	end

	if storeItem.bundleInfo ~= nil then
		for _, bundleItem in ipairs(storeItem.bundleInfo.bundleItems) do
			if configurations == nil then
				configurations = {}
			end

			for configName, data in pairs(bundleItem.preSelectedConfigurations) do
				configurations[configName] = data.configValue
			end

			fillTypeIconFilenames = getIconFilenamesForSpec(fillTypesSpec, bundleItem.item, nil, configurations)
			seedTypeIconFilenames = getIconFilenamesForSpec(seedFillTypeSpec, bundleItem.item, nil, configurations)
			foodFillTypeIconFilenames = getIconFilenamesForSpec(foodFillTypesSpec, bundleItem.item, nil, configurations)
		end
	else
		fillTypeIconFilenames = getIconFilenamesForSpec(fillTypesSpec, storeItem, realItem)
		seedTypeIconFilenames = getIconFilenamesForSpec(seedFillTypeSpec, storeItem, realItem)
		foodFillTypeIconFilenames = getIconFilenamesForSpec(foodFillTypesSpec, storeItem, realItem)
		prodPointInputFillTypeIconFilenames = getIconFilenamesForSpec(prodPointInputFillTypesSpec, storeItem, realItem)
		prodPointOutputFillTypeIconFilenames = getIconFilenamesForSpec(prodPointOutputFillTypesSpec, storeItem, realItem)
		sellingStationFillTypesIconFilenames = getIconFilenamesForSpec(sellingStationFillTypesSpec, storeItem, realItem)
		objectStorageFillTypesIconFilenames = getIconFilenamesForSpec(objectStorageFillTypesSpec, storeItem, realItem)
		siloExtensionFillTypesIconFilenames = getIconFilenamesForSpec(siloExtensionFillTypesSpec, storeItem, realItem)
		siloFillTypesIconFilenames = getIconFilenamesForSpec(siloFillTypesSpec, storeItem, realItem)
	end

	local iconFilenames = {
		fillTypeIconFilenames = fillTypeIconFilenames,
		seedTypeIconFilenames = seedTypeIconFilenames,
		foodFillTypeIconFilenames = foodFillTypeIconFilenames,
		prodPointInputFillTypeIconFilenames = prodPointInputFillTypeIconFilenames,
		prodPointOutputFillTypeIconFilenames = prodPointOutputFillTypeIconFilenames,
		sellingStationFillTypesIconFilenames = sellingStationFillTypesIconFilenames,
		objectStorageFillTypesIconFilenames = objectStorageFillTypesIconFilenames,
		siloExtensionFillTypesIconFilenames = siloExtensionFillTypesIconFilenames,
		siloFillTypesIconFilenames = siloFillTypesIconFilenames
	}
	local descriptionText = ""
	if storeItem.functions ~= nil and #storeItem.functions >= 1 then
	descriptionText = table.concat(storeItem.functions, " ")
	end
	local category = g_storeManager:getCategoryByName(storeItem.categoryName)
	local numOwned, numLeased = nil

	if g_currentMission ~= nil then
		if StoreItemUtil.getIsLeasable(storeItem) then
			numOwned = g_currentMission:getNumOwnedItems(storeItem, g_currentMission:getFarmId())

			if not GS_IS_MOBILE_VERSION then
				numLeased = g_currentMission:getNumLeasedItems(storeItem, g_currentMission:getFarmId())
			end
		elseif not StoreItemUtil.getIsObject(storeItem) then
			numOwned = g_currentMission:getNumOfItems(storeItem, self.playerFarmId)
		end
	end

	return ShopDisplayItem.new(storeItem, realItem, attributeIconProfiles, attributeValues, iconFilenames, descriptionText, category.orderId, numOwned, numLeased, saleItem)
end

function extendedFarmsiloShopDisplay.ShopDisplayItemNew(storeItem, superFunc, concreteItem, attributeIconProfiles, attributeValues, iconFilenames, functionText, orderValue, numOwned, numLeased, saleItem)
	local self = superFunc(storeItem, concreteItem, attributeIconProfiles, attributeValues, iconFilenames, functionText, orderValue, numOwned, numLeased, saleItem)

	if iconFilenames ~= nil then
		self.siloExtensionFillTypesIconFilenames = iconFilenames.siloExtensionFillTypesIconFilenames or {}
		self.siloFillTypesIconFilenames = iconFilenames.siloFillTypesIconFilenames or {}
	end

	return self
end

function extendedFarmsiloShopDisplay.ConstructionScreenAssignItemAttributeData(self, superFunc, storeItem)
	for k, clone in pairs(self.clonedElements) do
		clone:delete()
		self.clonedElements[k] = nil
	end
	for k, _ in pairs(self.marqueeBoxes) do
		self.marqueeBoxes[k] = nil
	end
	local displayItem
	if storeItem == nil then
		displayItem = nil
	else
		self.itemDetailsName:setText(storeItem.name)
		displayItem = storeItem.displayItem
	end
	self.itemDetailsName:setVisible(storeItem ~= nil)
	self.attributesLayout:setVisible(displayItem ~= nil)
	if displayItem == nil then
		self.itemDetailsBrandImage:setVisible(false)
		self.itemDetailsModName:setVisible(false)
		self.itemDetailsDescription:setVisible(false)
	else
		for index = #self.attributesLayout.elements, 1, -1 do
			self:queueDetailsCell(self.attributesLayout.elements[index])
		end
		self:assignItemTextData(displayItem)
		self:assignItemFillTypesData(ShopItemsFrame.PROFILE.ICON_FILL_TYPES, displayItem.fillTypeIconFilenames)
		self:assignItemFillTypesData(ShopItemsFrame.PROFILE.ICON_FILL_TYPES, displayItem.foodFillTypeIconFilenames)
		self:assignItemFillTypesData(ShopItemsFrame.PROFILE.ICON_INPUT, displayItem.prodPointInputFillTypeIconFilenames)
		self:assignItemFillTypesData(ShopItemsFrame.PROFILE.ICON_OUTPUT, displayItem.prodPointOutputFillTypeIconFilenames)
		self:assignItemFillTypesData(ShopItemsFrame.PROFILE.ICON_INPUT, displayItem.sellingStationFillTypesIconFilenames)
		self:assignItemFillTypesData(ShopItemsFrame.PROFILE.ICON_OUTPUT, displayItem.buyingStationFillTypesIconFilenames)
		self:assignItemFillTypesData(ShopItemsFrame.PROFILE.ICON_FILL_TYPES, displayItem.objectStorageFillTypesIconFilenames)
		self:assignItemFillTypesData(ShopItemsFrame.PROFILE.ICON_FILL_TYPES, displayItem.siloExtensionFillTypesIconFilenames)
		self:assignItemFillTypesData(ShopItemsFrame.PROFILE.ICON_FILL_TYPES, displayItem.siloFillTypesIconFilenames)
		local brand, dlcTitle, functionText
		if displayItem.storeItem == nil then
			brand = nil
			dlcTitle = nil
			functionText = nil
		else
			brand = g_brandManager:getBrandByIndex(displayItem.storeItem.brandIndex)
			if brand ~= nil then
				self.itemDetailsBrandImage:setImageFilename(brand.image)
			end
			dlcTitle = displayItem.storeItem.dlcTitle
			functionText = displayItem.functionText
			self.itemDetailsDescription:setText(functionText)
			self.itemDetailsModName:setText(dlcTitle)
		end
		self.itemDetailsBrandImage:setVisible(brand ~= nil)
		self.itemDetailsModName:setVisible(dlcTitle ~= nil)
		self.itemDetailsDescription:setVisible(functionText ~= nil)
		self.descriptionLayout:invalidateLayout()
		self.attributesLayout:invalidateLayout()
	end
end

local function init()
	PlaceableSiloExtension.initSpecialization = extendedFarmsiloShopDisplay.PlaceableSiloExtensionInitSpecialization
	PlaceableSilo.initSpecialization = extendedFarmsiloShopDisplay.PlaceableSiloInitSpecialization
	PlaceableSiloExtension.loadSpecValueInputFillTypes = extendedFarmsiloShopDisplay.PlaceableSiloExtensionLoadSpecValueInputFillTypes
	PlaceableSiloExtension.getSpecValueInputFillTypes = extendedFarmsiloShopDisplay.PlaceableSiloExtensionGetSpecValueInputFillTypes
	PlaceableSilo.loadSpecValueInputFillTypes = extendedFarmsiloShopDisplay.PlaceableSiloLoadSpecValueInputFillTypes
	PlaceableSilo.getSpecValueInputFillTypes = extendedFarmsiloShopDisplay.PlaceableSiloGetSpecValueInputFillTypes
	ShopController.makeDisplayItem = Utils.overwrittenFunction(ShopController.makeDisplayItem, extendedFarmsiloShopDisplay.ShopControllerMakeDisplayItem)
	ShopDisplayItem.new = Utils.overwrittenFunction(ShopDisplayItem.new, extendedFarmsiloShopDisplay.ShopDisplayItemNew)
	ConstructionScreen.assignItemAttributeData = Utils.overwrittenFunction(ConstructionScreen.assignItemAttributeData, extendedFarmsiloShopDisplay.ConstructionScreenAssignItemAttributeData)
end

init()






